define({"topics" : [{"title":"Getting started with administrator accounts","shortdesc":"<p class=\"shortdesc\">An administrator account specifies the actions for which the administrator has permissions, such as creating elements and browsing logs. <\/p>","id":"GUID-D3E14745-FE82-41DE-98BA-10D370C701EE","href":"GUID-D3E14745-FE82-41DE-98BA-10D370C701EE.html","menu": {"hasChildren":false,},"tocID":"GUID-D3E14745-FE82-41DE-98BA-10D370C701EE-d58e22736","topics":[]},{"title":"How administrator accounts work","shortdesc":"<p class=\"shortdesc\"> Many elements are used in the configuration of administrator accounts, including <span class=\"keyword\">Security Engine<\/span>, Policy, Access Control List, Administrator Role, and \t\tFilter elements. <\/p>","id":"GUID-F8C6ABE0-B69E-4454-B599-5B0412675C5F","href":"GUID-F8C6ABE0-B69E-4454-B599-5B0412675C5F.html","menu": {"hasChildren":false,},"tocID":"GUID-F8C6ABE0-B69E-4454-B599-5B0412675C5F-d58e22767","topics":[]},{"title":"Default administrator account elements ","shortdesc":"<p class=\"shortdesc\"> There are several predefined Administrator Roles and Access Control Lists that help you configure Administrator permissions. You cannot edit the predefined elements.    <\/p>","id":"GUID-78246E7E-9CF2-4E13-88E4-938910A9E0D4","href":"GUID-78246E7E-9CF2-4E13-88E4-938910A9E0D4.html","menu": {"hasChildren":false,},"tocID":"GUID-78246E7E-9CF2-4E13-88E4-938910A9E0D4-d58e22801","topics":[]},{"title":"Administrator account configuration overview","shortdesc":"<p class=\"shortdesc\">You must configure an administrator account for each administrator. You can create customized task and element lists that can be used to define permissions for administrators.    <\/p>","id":"GUID-92CD635D-BCD3-4589-BA96-E804199CB1FD","href":"GUID-92CD635D-BCD3-4589-BA96-E804199CB1FD.html","menu": {"hasChildren":false,},"tocID":"GUID-92CD635D-BCD3-4589-BA96-E804199CB1FD-d58e22832","topics":[]},{"title":"Creating Administrator Role and Access Control List elements","shortdesc":"<p class=\"shortdesc\"> You can use Administrator Role and Access Control List elements in accounts that define restricted administrator permissions.    <\/p>","id":"GUID-E43CF921-50A1-425A-9680-63272DAE557D","href":"GUID-E43CF921-50A1-425A-9680-63272DAE557D.html","menu": {"hasChildren":true,},"tocID":"GUID-E43CF921-50A1-425A-9680-63272DAE557D-d58e22863","next":"GUID-E43CF921-50A1-425A-9680-63272DAE557D-d58e22863",},{"title":"Add administrator accounts","shortdesc":"<p class=\"shortdesc\">Administrator elements represent administrator accounts in the <span class=\"keyword\">SMC<\/span>. Administrators configure and monitor the <span class=\"keyword\">SMC<\/span> and the <span class=\"keyword\">Security Engine<\/span>s. <\/p>","id":"GUID-EEA39D1D-8D27-482B-9C96-F52583E925AF","href":"GUID-EEA39D1D-8D27-482B-9C96-F52583E925AF.html#GUID-EEA39D1D-8D27-482B-9C96-F52583E925AF","menu": {"hasChildren":false,},"tocID":"GUID-EEA39D1D-8D27-482B-9C96-F52583E925AF-d58e23056","topics":[]},{"title":"Enforce an approval workflow","shortdesc":"<p class=\"shortdesc\">You can optionally enable an approval workflow in which an administrator must approve changes before they are committed and transferred \t\tto the engines.<\/p>","id":"GUID-CD81DFD9-143D-4A8B-A63E-65288E3ADA3B","href":"GUID-CD81DFD9-143D-4A8B-A63E-65288E3ADA3B.html#GUID-CD81DFD9-143D-4A8B-A63E-65288E3ADA3B","menu": {"hasChildren":false,},"tocID":"GUID-CD81DFD9-143D-4A8B-A63E-65288E3ADA3B-d58e23146","topics":[]},{"title":"Restrict the log data an administrator can view","shortdesc":"<p class=\"shortdesc\"> If an administrator is allowed to view logs and alerts, you apply local filters to the log data before it is displayed to the administrator.    <\/p>","id":"GUID-8C1B7F5A-E5B1-4772-B88C-7AB713D71621","href":"GUID-8C1B7F5A-E5B1-4772-B88C-7AB713D71621.html#GUID-8C1B7F5A-E5B1-4772-B88C-7AB713D71621","menu": {"hasChildren":false,},"tocID":"GUID-8C1B7F5A-E5B1-4772-B88C-7AB713D71621-d58e23208","topics":[]},{"title":"Customize log colors for administrators","shortdesc":"<p class=\"shortdesc\"> By default, certain logs are shown with a colored background in the  \t <span class=\"ph uicontrol\">Logs<\/span> view. Using administrator-specific log colors makes it easier to draw the administrator’s attention to particular logs.    <\/p>","id":"GUID-3EE25B52-886E-4611-8684-34F0CEA42B18","href":"GUID-3EE25B52-886E-4611-8684-34F0CEA42B18.html#GUID-3EE25B52-886E-4611-8684-34F0CEA42B18","menu": {"hasChildren":false,},"tocID":"GUID-3EE25B52-886E-4611-8684-34F0CEA42B18-d58e23301","topics":[]},{"title":"Replicate administrator accounts","shortdesc":"<p class=\"shortdesc\">You can replicate  \t <span class=\"keyword\">SMC<\/span> administrator accounts as local administrator accounts on selected engines. This enables several administrators to access an engine locally with the security privileges of the root user.    <\/p>","id":"GUID-0BEF6F49-9BE3-42E0-AAC3-48C1BD4D7DE7","href":"GUID-0BEF6F49-9BE3-42E0-AAC3-48C1BD4D7DE7.html#GUID-0BEF6F49-9BE3-42E0-AAC3-48C1BD4D7DE7","menu": {"hasChildren":false,},"tocID":"GUID-0BEF6F49-9BE3-42E0-AAC3-48C1BD4D7DE7-d58e23397","topics":[]},{"title":"Enable and define password policy settings","shortdesc":"<p class=\"shortdesc\">If you authenticate administrators or Web Portal users with internal authentication, you can enforce a password policy.    <\/p>","id":"GUID-6FA9C9E0-DD96-46F6-BDA0-845D2B54173F","href":"GUID-6FA9C9E0-DD96-46F6-BDA0-845D2B54173F.html#GUID-6FA9C9E0-DD96-46F6-BDA0-845D2B54173F","menu": {"hasChildren":false,},"tocID":"GUID-6FA9C9E0-DD96-46F6-BDA0-845D2B54173F-d58e23463","topics":[]},{"title":"Change administrator passwords","shortdesc":"<p class=\"shortdesc\"> If you have not configured administrator passwords to automatically expire, we recommend that you change administrator passwords regularly.   <\/p>","id":"GUID-EE13F78B-2760-47EE-9AD6-7EB5C504E7AA","href":"GUID-EE13F78B-2760-47EE-9AD6-7EB5C504E7AA.html","menu": {"hasChildren":true,},"tocID":"GUID-EE13F78B-2760-47EE-9AD6-7EB5C504E7AA-d58e23525","next":"GUID-EE13F78B-2760-47EE-9AD6-7EB5C504E7AA-d58e23525",},{"title":"Authenticate administrators using OpenID authentication method","shortdesc":"<p class=\"shortdesc\">You can authenticate administrators by using the OpenID connect authentication method to facilitate single sign-on to the SMC Web Access portal. An OpenID Provider is used to         authenticate administrators to grant access to the SMC Web Access portal.<\/p>","id":"guid-63408d91-42a4-4ab1-b51e-b46190bb88f9","href":"guid-63408d91-42a4-4ab1-b51e-b46190bb88f9.html","menu": {"hasChildren":false,},"tocID":"guid-63408d91-42a4-4ab1-b51e-b46190bb88f9-d58e23752","topics":[]},{"title":"Authenticate administrators using RADIUS or TACACS+ methods","shortdesc":"<p class=\"shortdesc\"> You can authenticate administrators and Web Portal users using RADIUS or TACACS+ authentication methods.    <\/p>","id":"GUID-26D7F914-2335-4D52-BE07-869BD6D165FD","href":"GUID-26D7F914-2335-4D52-BE07-869BD6D165FD.html","menu": {"hasChildren":false,},"tocID":"GUID-26D7F914-2335-4D52-BE07-869BD6D165FD-d58e23783","topics":[]},{"title":"Authenticate administrators on engines using the Radius authentication method","shortdesc":"<p class=\"shortdesc\">You can authenticate administrators on an engine by using the RADIUS authentication method.<\/p>","id":"guid-1870db78-cdb7-4bf3-b059-a15f81c14988","href":"guid-1870db78-cdb7-4bf3-b059-a15f81c14988.html","menu": {"hasChildren":false,},"tocID":"guid-1870db78-cdb7-4bf3-b059-a15f81c14988-d58e23814","topics":[]},{"title":"Authenticate administrators using SAML v2 authentication method","shortdesc":"<p class=\"shortdesc\">You can authenticate administrators by using a Security Assertion Markup Language (SAML) based identity providers to facilitate Single Sign-on (SSO) to the SMC Web Access         portal.<\/p>","id":"guid-e7f809ea-def1-48d5-bf09-48e067eb7eb1","href":"guid-e7f809ea-def1-48d5-bf09-48e067eb7eb1.html","menu": {"hasChildren":false,},"tocID":"guid-e7f809ea-def1-48d5-bf09-48e067eb7eb1-d58e23845","topics":[]},{"title":"Using LDAP authentication for administrators","shortdesc":"<p class=\"shortdesc\">When you use LDAP authentication for administrators, administrator accounts are linked to user accounts in an integrated external directory server. The external directory server where the         user accounts are stored verifies the user credentials.<\/p>","id":"GUID-B60A74EE-6D19-4E1D-948F-108B4F249E85","href":"GUID-B60A74EE-6D19-4E1D-948F-108B4F249E85.html","menu": {"hasChildren":false,},"tocID":"GUID-B60A74EE-6D19-4E1D-948F-108B4F249E85-d58e23876","topics":[]},{"title":"Authenticate administrators using certificate-based authentication","shortdesc":"<p class=\"shortdesc\"> You can authenticate administrators using an X.509 certificate stored in the Windows certificate store, on a smart card like a Common Access Card (CAC), or via SMC Web Access.<\/p>","id":"ed3fab0a-1d5c-43ac-a6a6-a13c72369730","href":"ed3fab0a-1d5c-43ac-a6a6-a13c72369730.html","menu": {"hasChildren":true,},"tocID":"ed3fab0a-1d5c-43ac-a6a6-a13c72369730-d58e23907","next":"ed3fab0a-1d5c-43ac-a6a6-a13c72369730-d58e23907",},{"title":"Disable administrator accounts","shortdesc":"<p class=\"shortdesc\"> If an administrator account is no longer needed, you can disable the administrator account to remove access for the administrator.    <\/p>","id":"GUID-F5F97D1C-7289-46B8-A177-5DFBB5216AAF","href":"GUID-F5F97D1C-7289-46B8-A177-5DFBB5216AAF.html","menu": {"hasChildren":false,},"tocID":"GUID-F5F97D1C-7289-46B8-A177-5DFBB5216AAF-d58e24220","topics":[]},{"title":"Delete administrator accounts","shortdesc":"<p class=\"shortdesc\"> When you permanently delete an administrator account, all history of changes the administrator has made to elements is also deleted permanently.    <\/p>","id":"GUID-028E16BE-0B3E-4EF2-B084-FA17186E1344","href":"GUID-028E16BE-0B3E-4EF2-B084-FA17186E1344.html","menu": {"hasChildren":false,},"tocID":"GUID-028E16BE-0B3E-4EF2-B084-FA17186E1344-d58e24251","topics":[]},{"title":"API client accounts and how they work","shortdesc":"<p class=\"shortdesc\"> You can use the application programming interface (API) of the  \t <span class=\"keyword\">SMC<\/span> to run certain actions in the  \t <span class=\"keyword\">SMC<\/span> remotely using an external application or script.    <\/p>","id":"GUID-6FE3431D-5094-44AD-8417-6C3E844881C6","href":"GUID-6FE3431D-5094-44AD-8417-6C3E844881C6.html#GUID-6FE3431D-5094-44AD-8417-6C3E844881C6","menu": {"hasChildren":false,},"tocID":"GUID-6FE3431D-5094-44AD-8417-6C3E844881C6-d58e24282","topics":[]},{"title":"Configure <span class=\"keyword\">SMC<\/span> API","shortdesc":"<p class=\"shortdesc\">The Application Programming Interface (API) of <span class=\"keyword\">SMC<\/span> allows external applications to connect with the       <span class=\"keyword\">SMC<\/span>. <\/p>","id":"GUID-E250EE31-3C52-4C21-BF0D-280301C88023","href":"GUID-E250EE31-3C52-4C21-BF0D-280301C88023.html","menu": {"hasChildren":true,},"tocID":"GUID-E250EE31-3C52-4C21-BF0D-280301C88023-d58e24320","next":"GUID-E250EE31-3C52-4C21-BF0D-280301C88023-d58e24320",}]});